<?php
    function generateAddForm($fields, $folder) {
        $out = '';
        $out .= '<form method="POST" action="ajoute_'.$folder.'.php">';
        
        foreach ($fields as $field) {
            $out .= '<label for="' . $field['name'] . '">' . $field['label'] . '</label>';
            
            if ($field['type'] === 'text') {
                $out .= '<input type="text" name="' . $field['name'] . '" id="' . $field['name'] . '"placeholder="' . $field['placeholder'] . '" ' . $field['required'] .'>';
            } elseif ($field['type'] === 'textarea') {
                $out .= '<textarea name="' . $field['name'] . '" id="' . $field['name'] . '"></textarea>';
            } elseif ($field['type'] === 'select') {
                $out .= '<select name="' . $field['name'] . '" id="' . $field['name'] . '">';
                
                foreach ($field['options'] as $option) {
                    $out .= '<option value="' . $option['value'] . '">' . $option['label'] . '</option>';
                }
                
                $out .= '</select>';
            } elseif ($field['type'] === 'date') {
                $out .= '<input type="date" name="' . $field['name'] . '" id="' . $field['name'] . '" '.$field['required'].'>';
            } elseif ($field['type'] === 'tel') {
                $out .= '<input type="tel" name="' . $field['name'] . '" id="' . $field['name'] . '" pattern="' . $field['pattern'] . '" placeholder="' . $field['placeholder'] . '" ' . $field['required'] .'>';
            } elseif ($field['type'] === 'integer') {
                $out .= '<input type="integer" name="' . $field['name'] . '" id="' . $field['name'] . '" pattern="' . $field['pattern'] . '" placeholder="' . $field['placeholder'] . '" ' . $field['required'] .'>';
            }
        }
        $out .= '<label for="send"></label>';
        $out .= '<input type="submit" value="Envoyer !" class="send" id="send" required> ';
        $out .= '</form>';
        return $out;
    }

    function addDB($POST, $fields, $table, $folder) {
        require ('../connection.php');
        if ($db) {
            $requete = "INSERT INTO $table (";
            $values = "VALUES (";
            foreach ($fields as $field) {
                $requete .= $field['name'] . ', ';
                $values .= "'" . $_POST[$field['name']] . "', ";
            }
            try {
                $requete = substr($requete, 0, -2);
                $values = substr($values, 0, -2);
                $requete .= ') ';
                $requete .= $values . ');';
                echo $requete;
                $db->prepare($requete)->execute();
                header('Location: ../'.$folder.'/liste_'.$table.'.php');
            } catch (Execption $e) {
                $_SERVER['messages']['errors'] = "An error occured during insertion in database";
            }
        }
        return $requete;
    }

    function generateUpdateForm($fields, $values, $folder, $id) {
        $out = '';
        $out .= '<form method="POST" action="modifie_'.$folder.'.php?id='.$id.'">';
        
        foreach ($fields as $field) {
            $out .= '<label for="' . $field['name'] . '">' . $field['label'] . '</label>';
            
            if ($field['type'] === 'text') {
                $out .= '<input type="text" name="' . $field['name'] . '" id="' . $field['name'] . '"placeholder="' . $field['placeholder'] . '" ' . $field['required'] .' value="' . $values[0][$field['name']] . '">';
            } elseif ($field['type'] === 'textarea') {
                $out .= '<textarea name="' . $field['name'] . '" id="' . $field['name'] . '">' . $values[0][$field['name']] . '</textarea>';
            } elseif ($field['type'] === 'select') {
                $out .= '<select name="' . $field['name'] . '" id="' . $field['name'] . '">';
                
                foreach ($field['options'] as $option) {
                    $out .= '<option value="' . $option['value'] . '"';
                    if ($option['value'] === $values[0][$field['name']]) {
                        $out .= ' selected';
                    };
                    $out .= '">' . $option['label'] . '</option>';
                }
                
                $out .= '</select>';
            } elseif ($field['type'] === 'date') {
                $out .= '<input type="date" name="' . $field['name'] . '" id="' . $field['name'] . '" value="' . $values[$field['name']] . '" ' . $field['required'] .'>';
            } elseif ($field['type'] === 'tel') {
                $out .= '<input type="tel" name="' . $field['name'] . '" id="' . $field['name'] . '" pattern="' . $field['pattern'] . '" placeholder="' . $field['placeholder'] . '" ' . $field['required'] .' value="' . $values[0][$field['name']] . '">';
            } elseif ($field['type'] === 'integer') {
                $out .= '<input type="integer" name="' . $field['name'] . '" id="' . $field['name'] . '" pattern="' . $field['pattern'] . '" placeholder="' . $field['placeholder'] . '" ' . $field['required'] .' value="' . $values[0][$field['name']] . '">';
            }
        }
        $out .= '<label for="send"></label>';
        $out .= '<input type="submit" value="Modifier !" class="send" id="send" required> ';
        $out .= '</form>';
        return $out;
    }

    function updateDB($POST, $fields, $table, $folder, $id) {
        require ('../connection.php');
        if ($db) {
            $requete = "UPDATE $table SET ";
            foreach ($fields as $field) {
                $requete .= $field['name'] . "='" . $_POST[$field['name']] . "', ";
            }
            $requete = substr($requete, 0, -2);
            $requete .= " WHERE " . $id ."=". $_GET['id'] .";";
            try {
                echo $requete;
                $db->prepare($requete)->execute();
                header('Location: ../'.$folder.'/liste_'.$table.'.php');
            } catch (Execption $e) {
                $_SERVER['messages']['errors'] = "An error occured during insertion in database";
            }
        }
        return $requete;
    }

?>
